/*
 *	Image Library -- Configuration
 *
 *	(c) 2006 Pavel Charvat <pchar@ucw.cz>
 */

#undef LOCAL_DEBUG

#include "lib/lib.h"
#include "lib/conf.h"
#include "images/images.h"

#include <string.h>

/* ImageLib section */
uns image_trace;
uns image_max_dim = 0xffff;
uns image_max_bytes = ~0U;

static struct cf_section image_lib_config = {
  CF_ITEMS{
    CF_UNS("Trace", &image_trace),
    CF_UNS("ImageMaxDim", &image_max_dim),
    CF_UNS("ImageMaxBytes", &image_max_bytes),
    CF_END
  }
};

static void CONSTRUCTOR
images_init_config(void)
{
  cf_declare_section("ImageLib", &image_lib_config, 0);
}
