/*
 *	Sherlock Indexer -- Sorting of Attributes for Stage 2
 *
 *	(c) 2006 Martin Mares <mj@ucw.cz>
 */

#include "sherlock/sherlock.h"
#include "lib/getopt.h"
#include "lib/fastbuf.h"
#include "indexer/indexer.h"

#include <stdio.h>
#include <fcntl.h>
#include <stdlib.h>
#include <unistd.h>

#define SORT_PREFIX(x) info_##x
#define SORT_KEY struct card_info
#define SORT_PRESORT
#define SORT_REGULAR
#define SORT_INPUT_FB
#define SORT_OUTPUT_FB

static inline int
info_compare(struct card_info *a, struct card_info *b)
{
  COMPARE(a->attr.card, b->attr.card);
  return 0;
}

#include "lib/sorter.h"

int
main(int argc, char **argv)
{
  log_init(argv[0]);
  if (cf_getopt(argc, argv, CF_SHORT_OPTS, CF_NO_LONG_OPTS, NULL) >= 0 ||
      optind < argc)
  {
    fputs("This program supports only the following command-line arguments:\n" CF_USAGE, stderr);
    exit(1);
  }

  log(L_INFO, "Preparing attributes and notes for stage 2");

  struct fastbuf *attrs = index_bopen(fn_attributes, O_RDONLY);
  struct fastbuf *notes = index_bopen(fn_notes, O_RDONLY);
  struct fastbuf *infos = bopen_tmp(indexer_fb_size);
  struct card_info info;
  info.orig_card = 0;
  uns last_oid = 0;
  uns jumps = 0;
  while (breadb(attrs, &info.attr, sizeof(info.attr)) &&
	 breadb(notes, &info.note, sizeof(info.note)))
    {
      if (!(info.attr.flags & CARD_FLAG_EMPTY) &&
	  !(info.attr.flags & CARD_FLAG_DUP))
	{
	  bwrite(infos, &info, sizeof(info));
	  if (info.attr.card < last_oid)
	    jumps++;
	  last_oid = info.attr.card;
	}
      info.orig_card++;
    }
  log(L_INFO, "Stage 2 will receive %d objects", (uns)(btell(infos) / sizeof(struct card_info)));
  brewind(infos);

  if (jumps)
    {
      ITRACE("Sorting attributes (%d jumps found)", jumps);
      infos = info_sort(infos);
    }

  bconfig(infos, BCONFIG_IS_TEMP_FILE, 0);
  byte *fn = index_name(fn_card_info);
  if (rename(infos->name, fn) < 0)
    die("Cannot rename %s to %s: %m", infos->name, fn);
  bclose(infos);

  return 0;
}
