/*
 *	Sherlock Search Engine -- A template for result heap
 *
 *	(c) 1997--2006 Martin Mares <mj@ucw.cz>
 */

#define R_NOTE struct R(note)
#define R_HEAP struct R(heap)

struct R(note) {
  struct result_note n;
  uns heap_pos;				/* Back-link to the heap */
  R_NOTE_FIELDS
};

struct R(heap) {
  uns max_matches;
  R_NOTE **heap;
  uns num_matches;
  R_NOTE *first_note, *free_note;
  uns site_max;
};

#ifdef R_EMIT_CODE

static inline int
R(lt)(R_NOTE *a, R_NOTE *b)
{
  return a->n.q < b->n.q || a->n.q == b->n.q && a->n.sec_sort_key > b->n.sec_sort_key;
}

#define R_HEAP_LESS(a,b) R(lt)(a,b)
#define R_HEAP_SWAP(h,a,b,t) (t=h[a], h[a]=h[b], h[b]=t, h[a]->heap_pos=a, h[b]->heap_pos=b)

static void R(init)(struct mempool *pool, R_HEAP *h)
{
  /* Expects max_matches and site_max to be set */
  h->num_matches = 0;
  h->heap = mp_alloc(pool, sizeof(R_NOTE *) * (h->max_matches+1));
  h->first_note = mp_alloc(pool, sizeof(R_NOTE) * (h->max_matches+1) + 1);
  h->free_note = h->first_note++;
}

static R_NOTE *R(get_note)(R_HEAP *h)
{
  return h->free_note;
}

static int R(insert)(R_HEAP *h, R_NOTE *note)
{
    {
      if (h->num_matches >= h->max_matches)
	{
	  if (note->n.q < h->heap[1]->n.q) /* Q too low -> throw away */
	    {
	      HDBG("\tWorse than Q=%d", h->heap[1]->n.q);
	      return 0;
	    }
	  h->free_note = h->heap[1];
	  HEAP_DELMIN(R_NOTE *, h->heap, h->num_matches, R_HEAP_LESS, R_HEAP_SWAP);
	  HDBG("\tDeleted minimum with Q=%d", h->free_note->n.q);
	}
      else
	h->free_note = h->first_note++;
    }
  h->heap[++h->num_matches] = note;
  note->heap_pos = h->num_matches;
  HEAP_INSERT(R_NOTE *, h->heap, h->num_matches, R_HEAP_LESS, R_HEAP_SWAP);
  return 1;
}

static R_NOTE * UNUSED R(delete_min)(R_HEAP *h)
{
  if (!h->num_matches)
    return NULL;
  else
    {
      HEAP_DELMIN(R_NOTE *, h->heap, h->num_matches, R_HEAP_LESS, R_HEAP_SWAP);
      return h->heap[h->num_matches+1];		/* A little trick */
    }
}

#endif

#undef R
#undef R_NOTE_FIELDS
#undef R_SITE_TYPE
#undef R_GET_SITE

#undef R_NOTE
#undef R_HEAP
#undef R_HEAP_LESS
#undef R_HEAP_SWAP
