#!/usr/bin/perl
# Find the call tree of memory allocations (using cscope)
# (c) 2004 Martin Mares <mj@ucw.cz>

# The set of allocator calls we want to trace
my @queue = (
	"xmalloc", "xmalloc_zero", "sh_xmalloc", "xfree", "free",
	"mmap_file", "munmap_file",
	"mp_new", "mp_delete",
	"resolve_fingerprints"
);
my %known = map { $_ => 2 } @queue;

# Preprocess the source and remove gcc attributes, because they confuse cscope
my $src = join(" ", @ARGV);
`gcc -C -E -P -I. $src | sed 's/__attribute__ *((.*))//g' >allocs.tmp`;
$? && die;
$src = "allocs.tmp";
unlink "cscope.out";
my %calls = ();

# Slurp file contents
open X, $src or die;
my @lines = <X>;
close X;

# Search the call graph backwards
while (@queue) {
	my $f = shift @queue;
	my @r = `cscope -I. -L -3 $f $src`;
	$? && die "cscope failed";
	foreach my $l (@r) {
		my ($ffile, $ffunc, $fline, $fctxt) = ($l =~ /^(\S+)\s+(\S+)\s+(\S+)\s*(.*)/) or die;
		print "$f -> $ffunc ($ffile:$fline) $fctxt\n";
		exists $calls{$ffunc} or $calls{$ffunc} = [];
		push @{$calls{$ffunc}}, "$fline:$f";
		if (!exists $known{$ffunc}) {
			$known{$ffunc} = 1;
			push @queue, $ffunc;
		}
	}
}
print "\n";

my %mark = ();
sub look($$$)
{
	my ($f,$i,$l) = @_;
	my $ll = "";
	if ($l) {
		$ll = $lines[$l-1];
		chomp $ll;
		$ll =~ s/^\s+//;
		$ll =~ s/\s+$//;
		$ll = "{ $ll }";
	}
	print "$i$f";
	if ($known{$f} > 1) {
		$mark{$f} = 1;
		print " $ll\n";
	} elsif (exists $mark{$f}) {
		print " ... $ll\n";
	} else {
		$mark{$f} = 1;
		print " $ll\n";
		foreach my $z (sort @{$calls{$f}}) {
			my ($zl,$zf) = split(/:/,$z);
			look($zf, "$i  ", $zl);
		}
	}
}

look("main", "", "");
