#!/usr/bin/perl
# Calculate timing statistics from log/sherlockd
# (c) 2001--2003 Martin Mares <mj@ucw.cz>

use strict;
use warnings;

open(LOG, "bin/cs2cs utf-8 iso-8859-2 |") || die "No log";
my $cnt=0;
print "Parsing log and dumping errors:\n";
my @hourly = map { 0 } 1..24;
my $current_date = '';
my $current_hour = 0;
my $current_total = 0;
my @queries = ();
my @timing = ();
my %profs = ();
my %cnts = ();
while (<LOG>) {
	/^[^ID] / && print;
	my ($date,$hour,$msg) = m/^. (\d{4}-\d{2}-\d{2} (\d{2})):\d{2}:\d{2} (.*)\n/ or die "Syntax error: $_";
	$_ = $msg;
	if (/^[0-9.]+ < (.*)/) {
		$queries[++$cnt] = $1;
		$timing[$cnt] = {};
		if ($current_date ne $date) {
			print "# $current_date $current_total\n" if $current_date;
			$current_date = $date;
			$current_hour = $hour;
			$current_total = 0;
		}
		if (++$current_total > $hourly[$current_hour]) { $hourly[$current_hour] = $current_total; }
	} elsif (/^> \d+ (.*)/) {
		my $t = $1;
		my $h = $timing[$cnt];
		$t =~ s/(\w+)[=]([0-9.]+)/$$h{$1}=$2; $profs{$1}=1; ""/ge;
		$t =~ s/(\w+)[:]([0-9.]+)/$$h{$1}=$2; $cnts{$1}=1; ""/ge;
	}
}
print "# $current_date $current_total\n" if $current_date;
print "Seen $cnt queries.\n";
$cnt || exit 0;
print "Hourly statistics:\n";
print "       ", join(" ", map { sprintf("%4d", $_) } 0..23), "\n";
print "Peaks: ", join(" ", map { sprintf("%4d", $_) } @hourly), "\n";
print "SPQ's: ", join(" ", map { $_ ? sprintf(($_ < 36 ? "%4.0f" : "%4.1f"), 3600/$_) : "????" } @hourly), "\n";

delete $profs{'t'};
my @timers = sort keys %profs;
unshift @timers, "t";
push @timers, sort keys %cnts;
foreach my $p (@timers) {
	if ($p eq "t") { print "Query times:\n"; }
	elsif (defined $profs{$p}) { print "prof_$p:\n"; }
	else { print "stat_$p:\n"; }
	my $tot = 0;
	my $peak = 0;
	my $ccnt = 0;
	for (my $i=0; $i<$cnt; $i++) {
		my $t = $timing[$i]{$p};
		if (defined $t) {
			$tot += $t;
			($t > $peak) && ($peak = $t);
			$ccnt++;
		}
	}
	print "\tCardinality: $ccnt\n";
	if ($ccnt) {
		printf "\tAverage: %.3f\n", $tot / $ccnt;
		print "\tPeak: $peak\n";
		my @rec = sort {
			if (!defined $timing[$b]{$p}) { -1; }
			elsif (!defined $timing[$a]{$p}) { 1; }
			else { $timing[$b]{$p} <=> $timing[$a]{$p} }
		} 0..$cnt-1;
		for (my $i=0; $i<10 && $i<$ccnt; $i++) {
			my $j = $rec[$i];
			print "\t[$i] ", $timing[$j]{$p}, " ", $queries[$j], "\n";
			my $tt = "";
			foreach my $q (@timers) {
				$tt .= " $q=" . $timing[$j]{$q} if (defined $timing[$j]{$q})
			}
			$tt =~ s/^\s+//;
			print "\t\t$tt\n";
		}
	}
}
