/*
 *	Sherlock Filter Engine -- Configuration
 *
 *	(c) 2002--2005 Robert Spalek <robert@ucw.cz>
 */

#include "sherlock/sherlock.h"
#include "lib/conf.h"
#include "filter/filter.h"

uns filter_trace = 0;
uns filter_hash_limit = 4;
uns filter_trie_limit = 4;
uns filter_tree_limit = 4;
uns filter_optimize = 1;
byte *filter_dump_to = NULL;

static struct cfitem fconfig[] = {
  { "Filter",		CT_SECTION,	NULL },
  { "Trace",		CT_INT,		&filter_trace },
  { "HashLimit",	CT_INT,		&filter_hash_limit },
  { "TrieLimit",	CT_INT,		&filter_trie_limit },
  { "TreeLimit",	CT_INT,		&filter_tree_limit },
  { "Optimize",		CT_INT,		&filter_optimize },
  { "DumpFilterTo",	CT_STRING,	&filter_dump_to },
  { NULL,		CT_STOP,	NULL }
};

static void CONSTRUCTOR fconfig_init(void)
{
  cf_register(fconfig);
}
