/*
 *	Sherlock Gatherer Daemon -- Configuration
 *
 *	(c) 1997--2002 Martin Mares <mj@ucw.cz>
 */

#include "sherlock/sherlock.h"
#include "gather/daemon/gatherd.h"
#include "lib/conf.h"

byte *log_name;
uns max_bucket_file_size;
uns max_host_count;
uns max_threads = 8;
uns trace_threads = 0;
uns min_server_delay = 5;
uns rec_err_dly1 = 60;
uns rec_err_limit = 3;
uns rec_err_dly2 = 3600;
uns trace_refs = 0;
uns max_rec_err = ~0;
uns auto_enqueue_root = 0;
uns ignore_refs = 0;
uns queue_cache_size = 16;
uns soft_max_obj_count = ~0;
uns hard_max_obj_count = ~0;
uns urldb_cache_size = 16;
uns md5db_cache_size = 16;
uns max_run_time = 3600;
uns dump_full_objects = 0;
uns auto_sync = 0;
uns max_resolvers = 1;
uns host_hash_size = 256;
uns key_hash_size = 256;
uns doc_change_mix = 128;
uns trickster_err_prob;
uns trickster_step = 1;
uns allow_hard_shutdown = 0;
int compress_level;
byte *host_file_name = "not/configured";
byte *host_bak_name = "not/configured";
byte *queue_file_name = "not/configured";
byte *lock_name = "not/configured";
byte *urldb_name = "not/configured";
byte *md5db_name = "not/configured";

static struct cfitem gatherd_config[] = {
  { "GatherD",		CT_SECTION,	NULL },
  { "LogFile",		CT_STRING,	&log_name },
  { "MaxBucketFileSize",	CT_INT,	&max_bucket_file_size },
  { "MaxHostCount",	CT_INT,		&max_host_count },
  { "MaxThreads",	CT_INT,		&max_threads },
  { "TraceThreads",	CT_INT,		&trace_threads },
  { "MinServerDelay",	CT_INT,		&min_server_delay },
  { "RecErrDelay1",	CT_INT,		&rec_err_dly1 },
  { "RecErrDelay2",	CT_INT,		&rec_err_dly2 },
  { "RecErrLimit",	CT_INT,		&rec_err_limit },
  { "TraceRefs",	CT_INT,		&trace_refs },
  { "MaxRecErr",	CT_INT,		&max_rec_err },
  { "AutoGoRoot",	CT_INT,		&auto_enqueue_root },
  { "IgnoreRefs",	CT_INT,		&ignore_refs },
  { "SoftMaxObj",	CT_INT,		&soft_max_obj_count },
  { "HardMaxObj",	CT_INT,		&hard_max_obj_count },
  { "QueueCacheSize",	CT_INT,		&queue_cache_size },
  { "URLDbCacheSize",	CT_INT,		&urldb_cache_size },
  { "MD5DbCacheSize",	CT_INT,		&md5db_cache_size },
  { "MaxRunTime",	CT_INT,		&max_run_time },
  { "DumpFullObjs",	CT_INT,		&dump_full_objects },
  { "AutoSync",		CT_INT,		&auto_sync },
  { "MaxResolvers",	CT_INT,		&max_resolvers },
  { "HostHashSize",	CT_INT,		&host_hash_size },
  { "KeyHashSize",	CT_INT,		&key_hash_size },
  { "HostFile",		CT_STRING,	&host_file_name },
  { "HostFileBak",	CT_STRING,	&host_bak_name },
  { "QueueFile",	CT_STRING,	&queue_file_name },
  { "LockFile",		CT_STRING,	&lock_name },
  { "URLDBFile",	CT_STRING,	&urldb_name },
  { "MD5DBFile",	CT_STRING,	&md5db_name },
  { "DocChangeMix",	CT_INT,		&doc_change_mix },
  { "TricksterErrProb",	CT_INT,		&trickster_err_prob },
  { "TricksterStep",	CT_INT,		&trickster_step },
  { "HardShutdown",	CT_INT,		&allow_hard_shutdown },
  { "Compress",		CT_INT,		&compress_level },
  { NULL,		CT_STOP,	NULL }
};

static void CONSTRUCTOR
read_config(void)
{
  cf_register(gatherd_config);
}
