/*
 *	Sherlock Gatherer -- Gatherer Configuration
 *
 *	(c) 2001--2004 Martin Mares <mj@ucw.cz>
 */

#include "sherlock/sherlock.h"
#include "lib/conf.h"
#include "lib/ipaccess.h"
#include "gather/gather.h"

uns max_obj_size = ~0;
uns allow_truncate = 1;
uns max_decode_size = ~0;
uns trace_decode;
uns log_ref_errors;
uns log_base_errors;
uns min_summed_size;
struct ipaccess_list *gaccess_list;
int min_ims_delay;
uns max_refresh_age = ~0U;
byte *gather_filter_name;
uns gather_min_compression = 100;
uns trace_resolve;

static byte *
gc_add_ipacc(struct cfitem *c, byte *b)
{
  return ipaccess_parse(gaccess_list, b, (c->name[0] == 'A'));
}

static struct cfitem gconfig[] = {
  { "Gather",		CT_SECTION,	NULL },
  { "MaxObjSize",	CT_INT,		&max_obj_size },
  { "AllowTruncate",	CT_INT,		&allow_truncate },
  { "MaxDecodeSize",	CT_INT,		&max_decode_size },
  { "TraceDecode",	CT_INT,		&trace_decode },
  { "Filter",		CT_STRING,	&gather_filter_name },
  { "LogRefErrors",	CT_INT,		&log_ref_errors },
  { "LogBaseErrors",	CT_INT,		&log_base_errors },
  { "MinSummedSize",	CT_INT,		&min_summed_size },
  { "AllowIP",		CT_FUNCTION,	gc_add_ipacc },
  { "DenyIP",		CT_FUNCTION,	gc_add_ipacc },
  { "MinIMSDelay",	CT_INT,		&min_ims_delay },
  { "MaxRefreshAge",	CT_INT,		&max_refresh_age },
  { "MinCompression",	CT_INT,		&gather_min_compression },
  { "TraceResolve",	CT_INT,		&trace_resolve },
  { NULL,		CT_STOP,	NULL }
};

static void CONSTRUCTOR gconf_init(void)
{
  cf_register(gconfig);
  gaccess_list = ipaccess_init();
}
