/*
 *	Sherlock Gatherer -- Filtering
 *
 *	(c) 2001--2002 Martin Mares <mj@ucw.cz>
 */

#include "sherlock/sherlock.h"
#include "lib/mempool.h"
#include "gather/gather.h"
#include "filter/filter.h"

static struct filter_binding gf_bindings[] = {
  /* URL and its parts */
  { "url",		OFFSETOF(struct gobject, url) },
  { "protocol",		OFFSETOF(struct gobject, url_s.protocol) },
  { "host",		OFFSETOF(struct gobject, url_s.host) },
  { "port",		OFFSETOF(struct gobject, url_s.port) },
  { "path",		OFFSETOF(struct gobject, url_s.rest) },
  /* Read-write version of url_s.user and url_s.pass */
  { "username",		OFFSETOF(struct gobject, auth_user) },
  { "password",		OFFSETOF(struct gobject, auth_pass) },
  /* Gatherer attributes */
  { "server_type",	OFFSETOF(struct gobject, http_server) },
  { "content_type",	OFFSETOF(struct gobject, content_type) },
  { "content_encoding",	OFFSETOF(struct gobject, content_encoding) },
  { "ignore_links",	OFFSETOF(struct gobject, dont_follow_links) },
  { "ignore_text",	OFFSETOF(struct gobject, dont_save_contents) },
  { NULL,		0 }
};

static struct filter *gf_filter;
static struct filter_args *gf_filter_args;

void
gather_init_filter(void)
{
  if (!gather_filter_name)
    return;
  gf_filter = filter_load(gather_filter_name, filter_builtin_vars, gf_bindings, NULL);
  gf_filter_args = filter_intr_new(gf_filter);
  filter_intr_undo_init(gf_filter_args);
}

void
gather_filter(void)
{
  guess_content();
  gthis->auth_user = gthis->url_s.user;
  gthis->auth_pass = gthis->url_s.pass;
  if (gf_filter)
    {
      struct filter_args *a = gf_filter_args;
      a->pool = gthis->pool;
      a->raw = gthis;
      a->attr = gthis->aa;
      if (!filter_intr_run(a) && !gthis->robot_file_p)
	gerror(2401, "%s", a->msg ? : (byte *) "Filtered out");
    }
  if (identify_content_encoding(gthis->content_encoding) < 0)
    gerror(2403, "Unknown content encoding %s", gthis->content_encoding);
  if (identify_content_type(gthis->content_type) < 0)
    gerror(2400, "Unknown content type %s", gthis->content_type);
}

void
gather_filter_undo(void)
{
  filter_intr_undo(gf_filter_args);
}
