/*
 *	Sherlock Indexer -- Configuration
 *
 *	(c) 2001--2004 Martin Mares <mj@ucw.cz>
 *	(c) 2002 Robert Spalek <robert@ucw.cz>
 */

#include "sherlock/sherlock.h"
#include "lib/conf.h"
#include "indexer/indexer.h"

#include <stdio.h>
#include <string.h>

byte *fn_directory;
byte *fn_source = "";
byte *fn_parameters;
byte *fn_fingerprints;
byte *fn_labels_by_id;
byte *fn_attributes;
byte *fn_checksums;
byte *fn_links;
byte *fn_urls;
byte *fn_ref_texts;
byte *fn_link_graph;
byte *fn_link_graph_index;
byte *fn_sites;
byte *fn_labels;
byte *fn_merges;
byte *fn_signatures;
byte *fn_matches;
byte *fn_word_index;
byte *fn_string_index;
byte *fn_lexicon;
byte *fn_lex_raw;
byte *fn_lex_ordered;
byte *fn_lex_words;
byte *fn_lex_by_freq;
byte *fn_stems;
byte *fn_stems_ordered;
byte *fn_references;
byte *fn_string_map;
byte *fn_string_hash;
byte *fn_cards;
byte *fn_card_attrs;
byte *fn_notes;
byte *fn_notes_new;
byte *fn_keywords;
byte *fn_feedback_gath;
byte *fn_card_prints;
byte *label_attrs = "";
byte *link_attrs = "";
byte *ref_link_types = "";
byte *indexer_filter_name;
byte *fn_lex_classes;
uns string_avg_bucket = 1024;
uns indexer_fb_size = 65536;
uns progress;
uns progress_screen;
uns progress_status_line;
uns sort_delete_src;
uns max_degree = 4096;
uns ref_max_length = 256;
uns ref_min_length = 1;
uns ref_max_count = 1;
uns matcher_signatures = 0;
uns matcher_context = 4;
uns matcher_min_words = 0;
uns matcher_threshold = 0;
uns matcher_passes = 3;
uns matcher_block = 64;
uns max_num_objects = ~0;
uns min_summed_size = 0;
uns auto_lang;
uns frameset_to_redir;
uns default_weight = 128;
uns ic_connect_timeout;
uns ic_reply_timeout;
uns ic_retry_count;
uns ic_retry_delay;
uns ic_send_feedback;

static struct cfitem iconfig[] = {
  { "Indexer",		CT_SECTION,	NULL },
  { "Directory",	CT_STRING,	&fn_directory },
  { "Source",		CT_STRING,	&fn_source },
  { "Parameters",	CT_STRING,	&fn_parameters },
  { "Fingerprints",	CT_STRING,	&fn_fingerprints },
  { "LabelsByID",	CT_STRING,	&fn_labels_by_id },
  { "Attributes",	CT_STRING,	&fn_attributes },
  { "Checksums",	CT_STRING,	&fn_checksums },
  { "Links",		CT_STRING,	&fn_links },
  { "URLList",		CT_STRING,	&fn_urls },
  { "RefTexts",		CT_STRING,	&fn_ref_texts },
  { "LinkGraph",	CT_STRING,	&fn_link_graph },
  { "LinkGraphIndex",	CT_STRING,	&fn_link_graph_index },
  { "Sites",		CT_STRING,	&fn_sites },
  { "Labels",		CT_STRING,	&fn_labels },
  { "Merges",		CT_STRING,	&fn_merges },
  { "Signatures",	CT_STRING,	&fn_signatures },
  { "Matches",		CT_STRING,	&fn_matches },
  { "WordIndex",	CT_STRING,	&fn_word_index },
  { "StringIndex",	CT_STRING,	&fn_string_index },
  { "Lexicon",		CT_STRING,	&fn_lexicon },
  { "LexRaw",		CT_STRING,	&fn_lex_raw },
  { "LexOrdered",	CT_STRING,	&fn_lex_ordered },
  { "LexWords",		CT_STRING,	&fn_lex_words },
  { "LexByFreq",	CT_STRING,	&fn_lex_by_freq },
  { "LexClasses",	CT_STRING,	&fn_lex_classes },
  { "Stems",		CT_STRING,	&fn_stems },
  { "StemsOrdered",	CT_STRING,	&fn_stems_ordered },
  { "References",	CT_STRING,	&fn_references },
  { "StringMap",	CT_STRING,	&fn_string_map },
  { "StringHash",	CT_STRING,	&fn_string_hash },
  { "Cards",		CT_STRING,	&fn_cards },
  { "CardAttributes",	CT_STRING,	&fn_card_attrs },
  { "Notes",		CT_STRING,	&fn_notes },
  { "NotesNew",		CT_STRING,	&fn_notes_new },
  { "Keywords",		CT_STRING,	&fn_keywords },
  { "FeedbackGatherer",	CT_STRING,	&fn_feedback_gath },
  { "CardPrints",	CT_STRING,	&fn_card_prints },
  { "LabelAttrs",	CT_STRING,	&label_attrs },
  { "LinkAttrs",	CT_STRING,	&link_attrs },
  { "Filter",		CT_STRING,	&indexer_filter_name },
  { "StringAvgBucket",	CT_INT,		&string_avg_bucket },
  { "FileBufSize",	CT_INT,		&indexer_fb_size },
  { "Progress",		CT_INT,		&progress },
  { "ProgressScreen",	CT_INT,		&progress_screen },
  { "ProgressStatusLine", CT_INT,	&progress_status_line },
  { "SortDeleteSrc",	CT_INT,		&sort_delete_src },
  { "MaxGraphDegree",	CT_INT,		&max_degree },
  { "RefLinkTypes",	CT_STRING,	&ref_link_types },
  { "RefMaxLength",	CT_INT,		&ref_max_length },
  { "RefMinLength",	CT_INT,		&ref_min_length },
  { "RefMaxCount",	CT_INT,		&ref_max_count },
  { "MaxObjects",	CT_INT,		&max_num_objects },
  { "MinSummedSize",	CT_INT,		&min_summed_size },
  { "AutoLang",		CT_INT,		&auto_lang },
  { "FramesetToRedir",	CT_INT,		&frameset_to_redir },
  { "DefaultWeight",	CT_INT,		&default_weight },
  { NULL,		CT_STOP,	NULL }
};

static struct cfitem matcher_config[] = {
  { "Matcher",		CT_SECTION,	NULL },
  { "Signatures",	CT_INT,		&matcher_signatures },
  { "Context",		CT_INT,		&matcher_context },
  { "MinWords",		CT_INT,		&matcher_min_words },
  { "Threshold",	CT_INT,		&matcher_threshold },
  { "Passes",		CT_INT,		&matcher_passes },
  { "Block",		CT_INT,		&matcher_block },
  { NULL,		CT_STOP,	NULL }
};

static void CONSTRUCTOR iconf_init(void)
{
  cf_register(iconfig);
  cf_register(matcher_config);
}

byte *
index_name(byte *file)
{
  if (!file)
    die("Missing indexer file name declarations in [Indexer]");
  if (!fn_directory)
    die("Indexer.Directory not set");
  if (file[0] == '/')
    return file;
  byte *buf = cfg_malloc(strlen(fn_directory) + strlen(file) + 2);
  sprintf(buf, "%s/%s", fn_directory, file);
  return buf;
}

int
index_name_defined(byte *file)
{
  return file && strcmp(file, "-");
}

uns card_count = ~0U;
