/*
 *	Sherlock Library -- LiZaRd Streams
 *
 *	(c) 2004, Robert Spalek <robert@ucw.cz>
 *
 *	This software may be freely distributed and used according to the terms
 *	of the GNU Lesser General Public License.
 */

#ifndef _SHERLOCK_LIZARD_FB_H
#define _SHERLOCK_LIZARD_FB_H

#include "lib/lizard.h"

struct fastbuf;

void lizard_set_type(uns type, float min_compr);
int lizard_bwrite(struct fastbuf *fb_out, byte *ptr_in, uns len_in);
int lizard_bbcopy_compress(struct fastbuf *fb_out, struct fastbuf *fb_in, uns len_in);
int lizard_memread(struct lizard_buffer *liz_buf, byte *ptr_in, byte **ptr_out, uns *type);
int lizard_bread(struct lizard_buffer *liz_buf, struct fastbuf *fb_in, byte **ptr_out, uns *type);
  /* These functions use static variables, hence they are not re-entrant.  */

#endif
