#!/bin/bash
#
#  Sherlock Index Distribution Script -- Receiving Part
#  (c) 2002--2004 Martin Mares <mj@ucw.cz>
#

set -e

function usage
{
	cat >&2 <<EOF
Usage: recv-index <index-name> <index-version> <index-files...>
EOF
	exit 1
}

[ -n "$3" ] || usage
INDEX=$1
NEW_VERSION=$2
shift 2
FILES="$@"

function log
{
	bin/logger recv-index I "$1"
}

function debug
{
	bin/logger recv-index D "$1"
}

function die
{
	bin/logger recv-index ! "$1"
	exit 1
}

OLD_VERSION=`bin/index-version $INDEX.new $FILES || true`;
debug "Current version of $INDEX.new: $OLD_VERSION"
if [ ${OLD_VERSION:0:1} != "<" ] ; then
	if [ $OLD_VERSION == $NEW_VERSION ] ; then
		log "$INDEX.new already has version $NEW_VERSION."
		exit 0
	else
		log "$INDEX.new has a different version $OLD_VERSION, replacing it."
	fi
fi

rm -rf $INDEX.old $INDEX.new
mkdir -p $INDEX.new
bin/file-recv $INDEX.new $FILES

X_VERSION=`bin/index-version $INDEX.new $FILES || true`;
log "Index version $X_VERSION received"
if [ $X_VERSION != $NEW_VERSION -a $NEW_VERSION != force-new ] ; then
	die "Version mismatch: expected $NEW_VERSION, received $X_VERSION"
fi
