#!/usr/bin/perl

#	Rotate Sherlock logs
#	(c) 2001--2002 Martin Mares <mj@ucw.cz>

use File::stat;

@ARGV >= 3 or die "Usage: rotate-log <days-to-compress> <date-to-delete> <logs...>";

$now = time;
$compress_thr = $now - 86400*shift @ARGV;
$delete_thr = $now - 86400*shift @ARGV;
foreach $f (@ARGV) {
	-f $f or next;
	$st = stat $f or next;
	if ($st->mtime < $delete_thr) {
		print "Deleting $f\n";
		unlink $f || die "Delete FAILED: $!";
	} elsif ($st->mtime < $compress_thr && $f !~ /\.(gz|bz2)$/) {
		print "Compressing $f\n";
		`gzip $f`;
		$? && die "Compression FAILED: $!";
	}
}
