/*
 *	Sherlock Utilities -- A Simple File Sizing Utility
 *
 *	(c) 2002 Martin Mares <mj@ucw.cz>
 */

#include "sherlock/sherlock.h"
#include "lib/lfs.h"

#include <stdio.h>
#include <string.h>

int
main(int argc, char **argv)
{
  int i;
  byte msg[256], *p;
  int err=0;

  log_init("sizer");
  if (argc < 2)
    die("Usage: sizer <file> ...");
  p = msg;
  for (i=1; i<argc; i++)
    {
      int fd;
      if (p + strlen(argv[i]) + 32 > msg + sizeof(msg))
	{
	  *p = 0;
	  log(L_INFO, "%s", msg+1);
	  p = msg;
	}
      p += sprintf(p, " %s=", argv[i]);
      fd = sh_open(argv[i], O_RDONLY, 0);
      if (fd < 0)
	{
	  *p++ = '?';
	  err = 1;
	}
      else
	{
	  sh_off_t len = sh_seek(fd, 0, SEEK_END);
	  if (len < 0)
	    {
	      *p++ = '?';
	      err = 1;
	    }
	  else
	    p += sprintf(p, "%Ld", (long long) len);
	  close(fd);
	}
    }
  if (p > msg)
    {
      *p = 0;
      log(L_INFO, "%s", msg+1);
    }
  return err;
}
