#!/usr/bin/perl -w
# Watson statistics
# (c) 2004 Tomas Valla <tom@ucw.cz>
# (c) 2006 Vladimir Jelen <vladimir.jelen@netcentrum.cz>

use lib "lib/perl5";
use Sherlock::Watsonlib;
use strict;
use warnings;

stat_options() or die stat_usage();

my $pic = new Sherlock::Watsonlib::picture $stat_picname, "Indexer: documents";
$pic->{INIT_CMD}.="set yrange [0:]\nset data style linespoints\n";
my $a = $pic->new_plot("Cards on scanner output");
my $b = $pic->new_plot("Documents on scanner input");
my %c = ();

read_config('INDEXER_INDICES');
my @indices = split /\s+/, read_config_value('INDEXER_INDICES');

foreach my $index (@indices) {
	$c{"$index"} = $pic->new_plot("Cards on chewer output (index $index)");
}

compute_stat($stat_begintime,$stat_endtime,$stat_prefix,\&proc_line);

$pic->draw_picture;

sub proc_line {
	my %r = @_;
	$pic->plot_value($a, $r{'start_time'}, $r{'scan_card'}) if defined $r{'scan_card'};
	$pic->plot_value($b, $r{'start_time'}, $r{'scan_doc'}) if defined $r{'scan_doc'};
	foreach my $index (keys %c) {
		$pic->plot_value($c{"$index"}, $r{'start_time'}, $r{"chewer_card_$index"}) if defined $r{"chewer_card_$index"};
	}
}

