#!/usr/bin/perl -w
# Watson statistics
# (c) 2004 Tomas Valla <tom@ucw.cz>
# (c) 2006 Vladimir Jelen <vladimir.jelen@netcentrum.cz>

use lib 'lib/perl5';
use Sherlock::Watsonlib;
use strict;
use warnings;

stat_options() or die stat_usage();

my $pic = new Sherlock::Watsonlib::picture $stat_picname, "Indexer: Index size";
$pic->{INIT_CMD}.="set yrange [0:]\nset data style linespoints\n";
my %t = ();

read_config('INDEXER_INDICES');
my @indices = split /\s+/, read_config_value('INDEXER_INDICES');

foreach my $index (@indices) {
	$t{"$index"} = $pic->new_plot("Index size - $index (MB)");
}

compute_stat($stat_begintime,$stat_endtime,$stat_prefix, sub {
	my %r = @_;
	foreach my $index (keys %t) {
		$pic->plot_value($t{"$index"}, $r{'start_time'}, $r{"size_total_$index"}/(1024*1024)) if defined $r{"size_total_$index"};
	}
});

$pic->draw_picture;
