#!/bin/bash
# Watson -- an elementary monitoring system for Sherlock Holmes
#
# (c) 2003-2005 Tomas Valla <tom@ucw.cz>
# (c) 2005 Vladimir Jelen <vladimir.jelen@netcentrum.cz>

if [ ! -f cf/watson ] ; then
	echo >&2 "Missing config file cf/watson !"
	exit 1
fi
. cf/watson
if [ -z "$DEFAULT_PATH" ] ; then
	echo >&2 "Missing config value DEFAULT_PATH !"
	exit 1
fi
if [ -z "$DEFAULT_LOG_PATH" ] ; then
	echo >&2 "Missing config value DEFAULT_LOG_PATH !"
	exit 1
fi

function clean_gz {
	for i in $1/*.{gz,bz2} ; do
		if [ -f "$i" ] ; then
			j=`echo -n "$i"|sed 's/\.\(gz\|bz2\)$//'`
			if [ -f "$j" ]; then
				echo "Deleting old $j"
				rm $j
			fi
		fi
	done
}

function download {	# download <from_server> <mask> <to> <comment> <days_to_delete> <days_to_compress> <days_backup>
	eval s=\$HOST_$1
	: ${s:=$1}
	eval p=\$PATH_$1
	: ${p:=$DEFAULT_PATH}
	eval l=\$LOG_PATH_$1
	: ${l:=$DEFAULT_LOG_PATH}
	if [ -z "$7" ]; then
		echo "Missing values in watson config file" 1>&2
	elif [ "$s" != "$s$l$2" ] ; then
		echo "Fetching $4 from $s:$l$2"
		rsync -vuat "$s:$l$2" "$3" && ssh "$s" "${p}bin/rotate-log" "$5" "$5" "$l$2" && bin/rotate-log "$6" "$7" $3$2
	fi
}

for s in $SEARCH_SERVERS ; do
	mkdir -p log/$s log/inter/$s
	download $s "$SEARCH_MASK" log/$s/ "search server" "$ROTATE_DELETE_SEARCH" "$ROTATE_COMPRESS_SEARCH" "$ROTATE_BACKUP_SEARCH"
done

[ -n "$GATHERD_SERVER" ] && download "$GATHERD_SERVER" "$GATHERD_MASK" log/ gatherer "$ROTATE_DELETE_GATHERD" "$ROTATE_COMPRESS_GATHERD" "$ROTATE_BACKUP_GATHERD"
[ -n "$INDEXER_SERVER" ] && download "$INDEXER_SERVER" "$INDEXER_MASK" log/ indexer "$ROTATE_DELETE_INDEXER" "$ROTATE_COMPRESS_INDEXER" "$ROTATE_BACKUP_INDEXER"
[ -n "$LEX_SERVER" ] && download "$LEX_SERVER" "$LEX_MASK"  log/words/ lexicon "$ROTATE_DELETE_LEX" "$ROTATE_COMPRESS_LEX" "$ROTATE_BACKUP_LEX"

[ -n "$ROTATE_COMPRESS_SEARCH" ] && [ -n "$ROTATE_BACKUP_SEARCH" ] && bin/rotate-log "$ROTATE_COMPRESS_SEARCH" "$ROTATE_BACKUP_SEARCH" log/$SEARCH_MASK
[ -n "$ROTATE_COMPRESS_REAP" ] && [ -n "$ROTATE_BACKUP_REAP" ] && bin/rotate-log "$ROTATE_COMPRESS_REAP" "$ROTATE_BACKUP_REAP" log/$REAP_MASK

function check () {
	PRG="$1"
	PTH="$2"
	shift 2
	for l ; do
		if [ -f $l ] ; then
			i=`echo -n "$l"|sed "s:^log/:$PTH:" | sed 's/\.[bg]z2\?//'`
			if [ ! \( -e "$i" \) -o \( "$l" -nt "$i" \) ]; then
				echo "Processing $l into $i"
				$PRG "$l" "$i"
			fi
		fi
	done
}

for s in $SEARCH_SERVERS ; do
	check bin/analyze-search log/inter/ log/"$s"/sherlockd-*
done
check bin/analyze-search log/inter/ log/sherlockd-*
check bin/analyze-gatherd log/inter/ log/gather*
check bin/analyze-indexer log/inter/ log/indexer-*
check bin/analyze-indexer-status log/inter/status- log/indexer-*

if [ "$ERROR_SEND" -gt 0 ] ; then
	ERROR_REPORT=`bin/log-gatherer-bugs log/gather-* log/mux-*`
	[ -n "$ERROR_REPORT" ] && echo "$ERROR_REPORT" | bin/send-mail -s "Gatherer & Mux errors" $ERROR_MAIL
fi
