# config.mk: Configurable parameters of Sherlock
# lib/autoconf.h is automatically generated from this file.

### Compiler options ###

# Choose which compiler should be used
CC=gcc
# C flags: tell the compiler we're speaking C99
CLANG=-std=gnu99
# C optimizations
COPT=-O2 -fstrict-aliasing -march=$(CPU_ARCH)
# Warnings
CWARNS=-Wall -W -Wno-parentheses -Wstrict-prototypes -Wmissing-prototypes -Winline
# Linker flags
LOPT=
# Extra libraries
LIBS=
# Extra flags for compiling and linking shared libraries
CSHARED=-fPIC
LSHARED=-shared -Wl,-soname,lib/$(@F)

# Extra switches depending on GCC version:
GCCVER:=$(shell $(CC) --version | sed '2,$$d; s/^\(.* \)\?\([0-9]*\.[0-9]*\).*/\2/')
ifeq ($(GCCVER),3.3)
CWARNS+=-Wundef -Wredundant-decls
COPT+=-finline-limit=20000 --param max-inline-insns-auto=1000
endif
ifeq ($(GCCVER),3.4)
CWARNS+=-Wundef -Wredundant-decls
COPT+=-finline-limit=5000 --param large-function-insns=5000 --param inline-unit-growth=150
endif

# If debugging:
#CDEBUG=-DDEBUG_ASSERTS -ggdb
#CDEBUG+=-DDEBUG_DIE_BY_ABORT

# If debugging memory allocations:
#LIBS+=-lefence
#CDEBUG+=-DDEBUG_DMALLOC
#LIBS+=-ldmalloc

# If building release versions:
CDEBUG=
COPT+=-fomit-frame-pointer
LOPT+=-s

### CPU Type and Features ###

CPU_ARCH=i386
CPU_I386=1
CPU_LITTLE_ENDIAN=1
#CPU_BIG_ENDIAN=1
CPU_ALLOW_UNALIGNED=1
CPU_STRUCT_ALIGN=4
#CPU_64BIT_POINTERS=1

### OS Type ###

CONFIG_LINUX=1

### Basic Modules (see free/config.mk for an explanation) ###

CONFIG_BARE=1
CONFIG_INDEXER=1
CONFIG_SEARCH=1

### Features ###

# Use shared libraries
#CONFIG_SHARED=1
# Searching by file type
#CONFIG_FILETYPE=1
# Language processing (requires CONFIG_FILETYPE)
#CONFIG_LANG=1
# Spelling checker
#CONFIG_SPELL=1
# Enable indexing of context-dependent words and set maximum number
# of context slots (undef, 256 or 32768). Lower values save memory, higher time.
#CONFIG_MAX_CONTEXTS=32768
# Debugging tools
#CONFIG_DEBUG=1
# Search server: Enable EXPLAIN command (slows searching down)
#CONFIG_EXPLAIN=1
# If your system doesn't contain GNU libc 2.3 or newer, it's recommended to let Sherlock
# use its own regex library (a copy of the glibc one), because the default regex library
# is likely to be crappy.
CONFIG_OWN_REGEX=1

### Installation ###

INSTALL_DIR=~/run
