/*
 *	Sherlock Indexer -- Handling of Attributes
 *
 *	(c) 2004 Martin Mares <mj@ucw.cz>
 */

static struct partmap *attrs_partmap UNUSED;
static struct card_attr *attrs UNUSED;

static inline void
attrs_map(uns rw)
{
  uns size;
  ASSERT(!attrs);
  attrs = mmap_file(index_name(fn_attributes), &size, rw);
  ASSERT(!(size % sizeof(struct card_attr)));
  set_card_count(size / sizeof(struct card_attr));
}

static inline void
attrs_unmap(void)
{
  ASSERT(attrs);
  munmap_file(attrs, card_count * sizeof(struct card_attr));
  attrs = NULL;
}

static inline void
attrs_part_map(uns rw)
{
  ASSERT(!attrs_partmap);
  attrs_partmap = partmap_open(index_name(fn_attributes), rw);
  ASSERT(!(partmap_size(attrs_partmap) % sizeof(struct card_attr)));
  set_card_count(partmap_size(attrs_partmap) / sizeof(struct card_attr));
}

static inline void
attrs_part_unmap(void)
{
  ASSERT(attrs_partmap);
  partmap_close(attrs_partmap);
  attrs_partmap = NULL;
}

static inline struct card_attr *
bring_attr(oid_t card)
{
  return partmap_map(attrs_partmap, sizeof(struct card_attr) * (sh_off_t)card, sizeof(struct card_attr));
}

#define READ_ATTR(var, field) do {						\
	ASSERT(sizeof(*var) == sizeof(((struct card_attr *)0)->field));		\
	var = xmalloc(card_count * sizeof(*var));				\
	for (uns i=0; i<card_count; i++)					\
	  var[i] = bring_attr(i)->field;					\
	} while(0)

#define READ_ATTR_BIT(var, field, mask) do {					\
	var = xmalloc(BIT_ARRAY_BYTES(card_count));				\
	bit_array_zero(var, card_count);					\
	for (uns i=0; i<card_count; i++)					\
	  if (bring_attr(i)->field & (mask))					\
	    bit_array_set(var, i);						\
	} while(0)

#define WRITE_ATTR(var, field) do { 						\
	for (uns i=0; i<card_count; i++)					\
	  bring_attr(i)->field = var[i];					\
	} while(0)
