/*
 *	Sherlock Search Engine -- Administration Commands
 *
 *	(c) 1997--2004 Martin Mares <mj@ucw.cz>
 */

#include "sherlock/sherlock.h"
#include "sherlock/index.h"
#include "indexer/params.h"
#include "search/sherlockd.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/time.h>

static void
cmd_databases(int argc UNUSED, byte **argv UNUSED)
{
  struct database *db;

  add_qerr("+OK");
  for(db=databases; db; db=db->next)
    {
      add_qr("D%s", db->name);
      if (db->params)
	{
	  add_qr("N%d", db->num_ids);
	  add_qr("I%d", db->params->objects_in);
	  add_qr("L%d", (int) db->params->ref_time);
	  add_qr("W%d", db->lexicon_words);
	  add_qr("C%d", db->lexicon_complexes);
	  add_qr("U%d", db->string_count);
	  add_qr("S%d", (int)((db->num_ids * sizeof(struct card_attr)
			       + db->card_file_size
			       + db->ref_file_size
			       + db->lexicon_file_size
			       + db->stems_file_size
			       + db->string_hash_file_size
			       + db->string_map_file_size
			       + 511) / 1024));
	}
      add_qr("%s", "");
    }
}

struct command {
  char *name;
  void (*handler)(int argc, byte **argv);
  int argmin, argmax, passwd;
};

static struct command cmds[] = {
  { "databases",	cmd_databases,	0, 0, 0 },
  { NULL,		NULL,		0, 0, 0 }
};

void
do_command(struct query *q)
{
  byte *c = q->cmd;
  byte *words[16], **argv;
  int argc;
  struct command *cmd = cmds;

  argc = wordsplit(c, words, ARRAY_SIZE(words));
  if (argc <= 0)
    {
      add_qerr("-109 Malformed command");
      return;
    }
  argv = words;
  argc--;
  while (cmd->name)
    {
      if (!strcasecmp(cmd->name, argv[0]))
	{
	  argv++;
	  if (cmd->passwd)
	    {
	      if (!argc || strcmp(control_password, argv[0]))
		{
		  add_qerr("-109 Invalid control password");
		  log(L_ERROR, "Invalid control password");
		  return;
		}
	      argc--, argv++;
	    }
	  if (argc < cmd->argmin || argc > cmd->argmax)
	    {
	      add_qerr("-109 Invalid number of parameters");
	      return;
	    }
	  cmd->handler(argc, argv);
	  return;
	}
      cmd++;
    }
  add_qerr("-109 Unknown control command");
}
