/*
 *	Sherlock Search Engine -- Buffering of Replies
 *
 *	(c) 1997--2001 Martin Mares <mj@ucw.cz>
 */

#include "sherlock/sherlock.h"
#include "lib/mempool.h"
#include "search/sherlockd.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>

struct replybuf *query_rbuf, *cache_rbuf;

void
init_reply_buf(struct replybuf *r, struct mempool *p)
{
  r->first = NULL;
  r->last = &r->first;
  r->pool = p;
}

void
reply_f(char *msg, ...)
{
  byte buf[4096];
  va_list args;
  uns l;

  va_start(args, msg);
  l = vsprintf(buf, msg, args);
  buf[l++] = '\n';
  reply_string(current_query, buf, l);
  va_end(args);
}

static struct reply *
make_reply(struct replybuf *rb, byte *msg, va_list args)
{
  byte buf[4096];
  struct reply *r;
  int l;

  l = vsnprintf(buf, sizeof(buf), msg, args);
  if (l < 0 || l >= (int)sizeof(buf))
    l = sprintf(buf, ".!TOO LONG!");
  if (log_replies > 1)
    log(L_INFO, ">> %s", buf);
  r = mp_alloc_fast(rb->pool, sizeof(struct reply) + l + 1);
  memcpy(r->text, buf, l);
  r->text[l++] = '\n';
  r->text[l] = 0;
  r->len = l;
  return r;
}

static void
add_reply_v(struct replybuf *rb, byte *msg, va_list args)
{
  struct reply *r;
  
  r = make_reply(rb, msg, args);
  *rb->last = r;
  rb->last = &r->next;
  r->next = NULL;
}

void
add_reply(struct replybuf *rb, char *msg, ...)
{
  va_list args;

  va_start(args, msg);
  add_reply_v(rb, msg, args);
  va_end(args);
}

static void
prepend_reply_v(struct replybuf *rb, byte *msg, va_list args)
{
  struct reply *r;
  
  r = make_reply(rb, msg, args);
  r->next = rb->first;
  if (!rb->first)
      rb->last = &r->next;
  rb->first = r;
}

void
ship_reply_buf(struct query *q, struct replybuf *rb)
{
  struct reply *r;

  for(r = rb->first; r; r=r->next)
    reply_string(q, r->text, r->len);
}

void
flush_reply_buf(struct query *q, struct replybuf *rb)
{
  ship_reply_buf(q, rb);
  init_reply_buf(rb, rb->pool);
}

struct reply *
first_reply_last(struct replybuf *rb)
{
  struct reply *r = rb->first;

  if (rb->last == &r->next)
    return r;
  rb->first = r->next;
  *rb->last = r;
  rb->last = &r->next;
  r->next = NULL;
  return r;
}

void
add_qr(char *msg, ...)
{
  va_list args;

  va_start(args, msg);
  add_reply_v(query_rbuf, msg, args);
  va_end(args);
}

void
add_cr(char *msg, ...)
{
  va_list args;

  va_start(args, msg);
  add_reply_v(cache_rbuf, msg, args);
  va_end(args);
}

void
add_qerr(char *msg, ...)
{
  va_list args;

  va_start(args, msg);
  prepend_reply_v(query_rbuf, msg, args);
  msg = query_rbuf->first->text;
  current_query->q_status = (msg[0]=='-') ? atol(msg+1) : 0;
  va_end(args);
}

void
add_cerr(char *msg, ...)
{
  va_list args;

  va_start(args, msg);
  prepend_reply_v(cache_rbuf, msg, args);
  va_end(args);
}
