#!/usr/bin/perl
# Generate data sets for speed benchmark from sherlockd log files
# (c) 2003 Martin Mares <mj@ucw.cz>

my $total = 0;
my $stats = 0;
my $nonimg = 0;
my $yesimg = 0;
my $multiw = 0;
my $boolean = 0;
my $phrase = 0;

while (<STDIN>) {
	chomp;
	/^I ....-..-.. ..:..:.. \S+ < (.*)/ || next;	
	$_ = $1;
	print "$_\n";
	$total++;
	/^STATS / and $stats++;
	/IMGTYPE\s*=\s*0/ and $nonimg++;
	/IMGTYPE\s*<>\s*0/ and $yesimg++;
	s/DB "[^"]+"/ /;
	/".*".*".*"/ and $multiw++;
	/ (AND|OR) / and $boolean++;
	/^[^"]*("[^" ]*"[^"]*)*"[^"]* / and $phrase++;
}

print STDERR "Total queries: $total\n";
print STDERR "STATS only: $stats\n";
print STDERR "Images: yes $yesimg, no $nonimg\n";
print STDERR "Multiword: $multiw, phrases $phrase, boolean $boolean\n";
