/*
 *	Get Index Version
 *
 *	(c) 2004 Martin Mares <mj@ucw.cz>
 */

#include "sherlock/sherlock.h"
#include "lib/lfs.h"
#include "lib/md5.h"
#include "sherlock/index.h"
#include "indexer/params.h"

#include <stdio.h>
#include <string.h>
#include <time.h>

int
main(int argc, char **argv)
{
  struct MD5Context mc;
  struct index_params para;
  int fd;

  if (argc < 2)
    die("Usage: index-version <index-dir> <files...>");
  if (chdir(argv[1]) < 0)
    {
      printf("<no-directory>\n");
      return 1;
    }

  fd = open("parameters", O_RDONLY);
  if (fd < 0)
    {
      printf("<no-params>\n");
      return 1;
    }
  if (read(fd, &para, sizeof(para)) != sizeof(para))
    {
      printf("<incompatible-params>\n");
      return 1;
    }
  if (!para.version)
    {
      printf("<incomplete>\n");
      return 1;
    }
  if (para.version != INDEX_VERSION)
    {
      printf("<unknown-version>\n");
      return 1;
    }
  close(fd);
  MD5Init(&mc);
  MD5Update(&mc, (byte*)&para, sizeof(para));

  for (int i=2; i<argc; i++)
    {
      fd = sh_open(argv[i], O_RDONLY, 0);
      if (fd < 0)
	{
	  printf("<missing-%s>\n", argv[i]);
	  return 1;
	}
      sh_off_t len = sh_seek(fd, 0, SEEK_END);
      MD5Update(&mc, (byte*)&len, sizeof(len));
      close(fd);
    }

  byte digest[MD5_SIZE], hex[MD5_HEX_SIZE];
  MD5Final(digest, &mc);
  md5_to_hex(digest, hex);
  printf("%08x-%.16s\n", para.ref_time, hex);

  return 0;
}
