#!/bin/bash
#
#  Sherlock Index Distribution Script -- Sending Part
#  (c) 2002--2004 Martin Mares <mj@ucw.cz>
#

set -e

function usage
{
	cat >&2 <<EOF
Usage: send-index <options> [<user>@]<search-server> <remote-homedir> <local-index-name> <remote-index-name>

Options:
--sendonly	Only upload the index, don't make it active
--force		Force index upload even if versions seem to match
EOF
	exit 1
}

SENDONLY=
FORCE=
while [ "${1:0:2}" == "--" ] ; do
	case "$1" in
		--sendonly)	SENDONLY=1
				;;
		--force)	FORCE=1
				;;
		*)		usage
				;;
	esac
	shift
done
[ -n "$4" -a -z "$5" ] || usage
SERVER=$1
SDIR=$2
LOCALINDEX=$3
REMINDEX=$4

function log
{
	bin/logger send-index I "$1"
}

function debug
{
	bin/logger send-index D "$1"
}

function cmd
{
	debug "Sending: set -e ; cd $SDIR ; $1"
	ssh $SERVER "set -e ; cd $SDIR ; $1"
}

function die
{
	bin/logger send-index ! "$1"
	exit 1
}

FILES=""
for a in cards card-attrs card-prints references lexicon stems string-map string-hash parameters ; do
	if [ -f $LOCALINDEX/$a ] ; then
		FILES="$FILES $a"
	fi
done
[ -n "$FILES" ] || die "No files to transfer!"

LOCALVER=`bin/index-version $LOCALINDEX$FILES || die 'Malformed local index'`
log "Sending index version $LOCALVER to $SERVER"
if [ -n "$FORCE" ] ; then
	LOCALVER="force-new"
fi
cmd "bin/recv-index $REMINDEX $LOCALVER$FILES" | bin/file-send $LOCALINDEX
[ ${PIPESTATUS[0]} = 0 ] || die "Index transfer failed"

if [ -n "$SENDONLY" ] ; then
	log "Index transferred."
	exit 0
fi

log "Switching indices..."
cmd "bin/scontrol swap $REMINDEX" || die "Swapping of indices FAILED! Please fix manually."
log "New index installed."
