#!/bin/bash
#
#  Sherlock Search Server Keeper Script
#  (c) 2002--2003 Martin Mares <mj@ucw.cz>
#

ulimit -c unlimited

if [ "$UID" = 0 ] ; then
	echo >&2 "skeeper: Must not be run as root!"
	exit 1
fi
if [ -n "$1" ] ; then
	echo >&2 "skeeper: You probably meant scontrol $@, didn't you?"
	exit 1
fi

eval `bin/config Search Port=8192 StatusFile '*'`
eval `bin/config SKeeper TestRetry TestWait CrashMail RotateLogs CrashWaitThreshold CrashWaitCeiling DaemonPIDFile KeeperPIDFile TestQuery SwapLock SwapLockTimeout`

DHO="--pid-file=$CF_DaemonPIDFile"
if [ -n "$CF_StatusFile" ] ; then
	DHO="$DHO --status-file=$CF_StatusFile"
fi

exec </dev/null >/dev/null 2>&1

function send_report
{
	if [ -n "$CF_CrashMail" ] ; then
		(
			HOST=`hostname`
			HOSTF=`hostname -f`
			CRM=`echo "$CF_CrashMail" | sed 's/ /, /g'`
			cat <<EOF
From: "Sherlock at $HOST" <`whoami`>
To: $CRM
Reply-To: $CRM
Subject: sherlockd $@

With sorrow in our hearts, we announce that sherlockd $@.

Host:			$HOSTF
Current directory:	`pwd`
Date and time:		`date`
Last words:
EOF
			tail -10 `ls -1t log/sherlockd* | head -1`
		) | /usr/sbin/sendmail $CF_CrashMail
	fi
}

leow=0
while true ; do
	bin/daemon-helper --start $DHO -- `pwd`/bin/sherlockd
	RC=$?
	[ $RC = 101 ] && exit 0  # Already running
	if [ -n "$CF_StatusFile" -a ! -s "$CF_StatusFile" ] ; then
		send_report "failed to start"
		exit 1
	else
		send_report "exited with return code $RC"
	fi
	now=`date +%s`
	if [ $(($now-$leow)) -gt $CF_CrashWaitThreshold ] ; then
		delay=1
	elif [ $delay -lt $CF_CrashWaitCeiling ] ; then
		delay=$((2*$delay))
	fi
	sleep $delay
	leow=$now
done
