#!/usr/bin/perl -w
# Watson statistics
# (c) 2004 Tomas Valla <tom@ucw.cz>

use lib "lib/perl5";
use Sherlock::Watsonlib;
use strict;
use warnings;

stat_options() or die stat_usage();

my $pic = new Sherlock::Watsonlib::picture $stat_picname, "Indexer: documents";
$pic->{INIT_CMD}.="set yrange [0:]\nset data style linespoints\n";
my $c = $pic->new_plot("Cards on chewer output");
my $d = $pic->new_plot("Cards on scanner output");
my $e = $pic->new_plot("Documents on scanner input");

compute_stat($stat_begintime,$stat_endtime,$stat_prefix,\&proc_line);

$pic->draw_picture;

sub proc_line {
	my %r = @_;
	$pic->plot_value($c, $r{'start_time'}, $r{'chewer_card'}) if defined $r{'chewer_card'};
	$pic->plot_value($d, $r{'start_time'}, $r{'scan_card'}) if defined $r{'scan_card'};
	$pic->plot_value($e, $r{'start_time'}, $r{'scan_doc'}) if defined $r{'scan_doc'};
}

