#!/bin/bash
# Watson -- an elementary monitoring system for Sherlock Holmes
#
# (c) 2003-2005 Tomas Valla <tom@ucw.cz>

# Configurable parameters:

SS="sherlock0 sherlock4 sherlock6 sherlock8 sherlock10"
GS="sherlock5:run/log/gather*"
IS="sherlock7:run/log/index*"
RS="sherlock2"
WS="sherlock7:run/log/words/lex-*"

function clean_gz () {
	for i in $1/*.{gz,bz2} ; do
		if [ -f "$i" ] ; then
			j=`echo -n "$i"|sed 's/\.\(gz\|bz2\)$//'`
			if [ -f "$j" ]; then
				echo "Deleting old $j"
				rm $j
			fi
		fi
	done
}

for s in $SS ; do
	echo "Fetching search server logs from $s"
	mkdir -p log/$s log/inter/$s
	rsync -vuat "$s:run/log/sherlock*" log/$s
	clean_gz log/$s
done

for s in $RS ; do
	echo "Fetching reapd logs from $s"
	mkdir -p log/$s log/inter/$s
	rsync -vuat "$s:run/log/reapd*" log/$s
	clean_gz log/$s
done

# commented in Centrum installation

# echo "Fetching gatherer logs from $GS"
# rsync -vuat "$GS" log

echo "Fetching indexer logs from $IS"
rsync -vuat "$IS" log

echo "Fetching word statistics from $WS"
mkdir -p log/words
rsync -vuat "$WS" log/words

function check () {
	PRG="$1"
	for l ; do
		i=`echo -n "$l"|sed 's:^log:log/inter:' | sed 's/\.[bg]z2\?//'`
		if [ ! \( -e "$i" \) -o \( "$l" -nt "$i" \) ]; then
			echo "Processing $l into $i"
			$PRG "$l" "$i"
		fi
	done
}

check bin/analyze-search log/sher*/sher*
check bin/analyze-gatherd log/gath*
check bin/analyze-indexer log/index*
