/*
 *	Sherlock Gatherer -- Interface to Analyser
 *
 *	(c) 2006 Martin Mares <mj@ucw.cz>
 */

#include "sherlock/sherlock.h"
#include "sherlock/object.h"
#include "analyser/analyser.h"
#include "gather/gather.h"

void
gather_init_analyser(void)
{
  analyser_init(AN_HOOK_GATHERER, AN_NEED_TEXT | AN_NEED_METAS | AN_NEED_ALL_URLS);
}

int
gather_analysis_needed(void)
{
  ASSERT(gthis->refreshing);
  struct an_iface ai = {
    .obj = gthis->refreshing,
    .url_block = gthis->refreshing,
    .all_urls = (struct odes *[]) { gthis->refreshing, NULL },
  };
  return analyser_need(&ai);
}

void
gather_analyse(void)
{
  struct odes *o = gthis->aa;
  struct an_iface ai = {
    .obj = o,
    .url_block = o,
    .all_urls = (struct odes *[]) { o, NULL }
  };

  /*
   * We need to temporarily create object attributes for stuff stored
   * in the gobject itself, because they might be needed by the analysers.
   * This is somewhat nasty, but hard to avoid without redesigning libgather.
   */
  obj_set_attr(o, 'T', gthis->content_type);
  obj_set_attr(o, 'l', gthis->language);

  uns need = analyser_need(&ai);
  if (need)
    {
      if ((need & AN_NEED_TEXT) && gthis->text)
	ai.text = fbmem_clone_read(gthis->text);
      if ((need & AN_NEED_METAS) && gthis->meta)
	ai.metas = fbmem_clone_read(gthis->meta);
      analyser_run_needed(&ai);
      bclose(ai.text);
      bclose(ai.metas);
    }

  /* Remove the temporary object attributes */
  obj_set_attr(o, 'T', NULL);
  obj_set_attr(o, 'l', NULL);

  /* And re-run the gatherer filter, because we might want to filter on analyser results */
  gather_filter(1);
}
