/*
 *	Sherlock: The index parameter file
 *
 *	(c) 2003--2006 Martin Mares <mj@ucw.cz>
 *	(c) 2005 Robert Spalek <robert@ucw.cz>
 */

#ifndef _SHERLOCK_PARAMS_H
#define _SHERLOCK_PARAMS_H

#include "indexer/lexicon.h"

struct index_params {
  u32 version;				/* INDEX_VERSION */
  sh_time_t ref_time;			/* Reference time (for document ages etc.) */
  struct lexicon_config lex_config;
  u32 objects_in;			/* Number of objects on the input of the indexer */
  u32 sites;				/* Number of unique sites */
  uns srand;				/* Random number generator setting for signatures */
  sh_time_t last_download;		/* Time of the newest document for the incremental scanner */
  u32 database_version;			/* Database version of this index */
  u16 type_mask;			/* Split indices: data type mask */
  u16 id_mask;				/* Split indices: document ID mask */
};

#endif
