/*
 *	Sherlock Indexer -- Merging two reference chains
 *
 *	(c) 2001--2003 Martin Mares <mj@ucw.cz>
 *	(c) 2005 Robert Spalek <robert@ucw.cz>
 *
 *	This procedure is used in ssort and wsort.
 */

#define OID_MASK	((1<<28) - 1)

static inline uns
bbcopy_chain(struct fastbuf *src, struct fastbuf *dest, uns ID)
{
  uns cnt, cnt2 = 0;
  bputl(dest, ID);
  if (ID >> 28)
    cnt = ID >> 28;
  else
    {
      cnt = bget_utf8_32(src);
      bput_utf8_32(dest, cnt);
      cnt2 = utf8_space(cnt);
    }
  bbcopy(src, dest, cnt);
  return cnt + cnt2;
}

static inline void
refchain_merge(struct fastbuf *src1, struct fastbuf *src2, struct fastbuf *dest)
{
  uns len1 = bgetl(src1);
  uns len2 = bgetl(src2);
  u32 ID1, ID2, id1, id2;

  bputl(dest, len1+len2);
  ID1 = bgetl(src1);
  id1 = ID1 & OID_MASK;
  len1 -= 4;
  ID2 = bgetl(src2);
  id2 = ID2 & OID_MASK;
  len2 -= 4;
  for(;;)
    {
      ASSERT(id1 != id2);
      if (id1 <= id2)
	{
	  len1 -= bbcopy_chain(src1, dest, ID1);
	  if (!len1)
	    goto end1;
	  ID1 = bgetl(src1);
	  id1 = ID1 & OID_MASK;
	  len1 -= 4;
	}
      else
	{
	  len2 -= bbcopy_chain(src2, dest, ID2);
	  if (!len2)
	    goto end2;
	  ID2 = bgetl(src2);
	  id2 = ID2 & OID_MASK;
	  len2 -= 4;
	}
    }

 end1:
  bputl(dest, ID2);
  bbcopy(src2, dest, len2);
  return;

 end2:
  bputl(dest, ID1);
  bbcopy(src1, dest, len1);
  return;
}
