#!/usr/bin/perl -w
# Watson statistics
# (c) 2005 Tomas Valla <tom@ucw.cz>

use lib "lib/perl5";
use Sherlock::Watsonlib;
use strict;
use warnings;

stat_options() or die stat_usage();

my $pic = new Sherlock::Watsonlib::picture $stat_picname, "Indexer: filetypes in";
$pic->{INIT_CMD}.="set yrange [0:]\nset data style linespoints\n";
my $a = $pic->new_plot("Unknown");
my $b = $pic->new_plot("HTML");
my $c = $pic->new_plot("PDF");
my $d = $pic->new_plot("Text");
my $e = $pic->new_plot("Word");
my $f = $pic->new_plot("Excel");
my $g = $pic->new_plot("JPEG");
my $h = $pic->new_plot("PNG");
my $i = $pic->new_plot("GIF");

compute_stat($stat_begintime,$stat_endtime,$stat_prefix,\&proc_line);

$pic->draw_picture;

sub proc_line {
	my %r = @_;
	$pic->plot_value($a, $r{'start_time'}, $r{'ft_in_unknown'}) if defined $r{'ft_in_unknown'};
	$pic->plot_value($b, $r{'start_time'}, $r{'ft_in_html'}) if defined $r{'ft_in_html'};
	$pic->plot_value($c, $r{'start_time'}, $r{'ft_in_pdf'}) if defined $r{'ft_in_pdf'};
	$pic->plot_value($d, $r{'start_time'}, $r{'ft_in_text'}) if defined $r{'ft_in_text'};
	$pic->plot_value($e, $r{'start_time'}, $r{'ft_in_msword'}) if defined $r{'ft_in_msword'};
	$pic->plot_value($f, $r{'start_time'}, $r{'ft_in_excel'}) if defined $r{'ft_in_excel'};
	$pic->plot_value($g, $r{'start_time'}, $r{'ft_in_jpeg'}) if defined $r{'ft_in_jpeg'};
	$pic->plot_value($h, $r{'start_time'}, $r{'ft_in_png'}) if defined $r{'ft_in_png'};
	$pic->plot_value($i, $r{'start_time'}, $r{'ft_in_gif'}) if defined $r{'ft_in_gif'};
}

