#!/usr/bin/perl -w
# Watson statistics
# (c) 2005 Tomas Valla <tom@ucw.cz>

use lib "lib/perl5";
use Sherlock::Watsonlib;
use strict;
use warnings;

stat_options() or die stat_usage();

my $pic = new Sherlock::Watsonlib::picture $stat_picname, "Indexer: languages";
$pic->{INIT_CMD}.="set yrange [0:]\nset data style linespoints\n";
my $a = $pic->new_plot("Unknown");
my $b = $pic->new_plot("English");
my $c = $pic->new_plot("Czech");
my $d = $pic->new_plot("Slovak");
my $e = $pic->new_plot("Polish");
my $f = $pic->new_plot("Hungarian");
my $g = $pic->new_plot("German");
my $h = $pic->new_plot("Dutch");
my $i = $pic->new_plot("French");
my $j = $pic->new_plot("Spanish");
my $k = $pic->new_plot("Italian");

compute_stat($stat_begintime,$stat_endtime,$stat_prefix,\&proc_line);

$pic->draw_picture;

sub proc_line {
	my %r = @_;
	$pic->plot_value($a, $r{'start_time'}, $r{'lang_unknown'}) if defined $r{'lang_unknown'};
	$pic->plot_value($b, $r{'start_time'}, $r{'lang_en'}) if defined $r{'lang_en'};
	$pic->plot_value($c, $r{'start_time'}, $r{'lang_cs'}) if defined $r{'lang_cs'};
	$pic->plot_value($d, $r{'start_time'}, $r{'lang_sk'}) if defined $r{'lang_sk'};
	$pic->plot_value($e, $r{'start_time'}, $r{'lang_pl'}) if defined $r{'lang_pl'};
	$pic->plot_value($f, $r{'start_time'}, $r{'lang_hu'}) if defined $r{'lang_hu'};
	$pic->plot_value($g, $r{'start_time'}, $r{'lang_de'}) if defined $r{'lang_de'};
	$pic->plot_value($h, $r{'start_time'}, $r{'lang_nl'}) if defined $r{'lang_nl'};
	$pic->plot_value($i, $r{'start_time'}, $r{'lang_fr'}) if defined $r{'lang_fr'};
	$pic->plot_value($j, $r{'start_time'}, $r{'lang_es'}) if defined $r{'lang_es'};
	$pic->plot_value($k, $r{'start_time'}, $r{'lang_it'}) if defined $r{'lang_it'};
}

