#!/usr/bin/perl -w
# Watson statistics
# (c) 2004 Tomas Valla <tom@ucw.cz>
# (c) 2006 Vladimir Jelen <vladimir.jelen@netcentrum.cz>

use lib 'lib/perl5';
use Sherlock::Watsonlib;
use strict;
use warnings;

stat_options() or die stat_usage();

my $pic = new Sherlock::Watsonlib::picture $stat_picname, "Indexer: lexicon";
$pic->{INIT_CMD}.="set yrange [0:]\nset data style linespoints\n";
my $t = $pic->new_plot("Number of words");
my %l = ();

read_config('INDEXER_INDICES');
my @indices = split /\s+/, read_config_value('INDEXER_INDICES');

foreach my $index (@indices) {
	$l{"$index"} = $pic->new_plot("Lexicon size - $index (MB)");
}

# FIXME
# This is disabled due to gnuplot stupidity... oh well... later
# $pic->{PLOT_USING}{$l} .= " axes x1y2";

compute_stat($stat_begintime,$stat_endtime,$stat_prefix, sub {
	my %r = @_;
	$pic->plot_value($t,$r{'start_time'}, $r{'mklex_words'}) if defined $r{'mklex_words'};
	foreach my $index (keys %l) {
		$pic->plot_value($l{"$index"}, $r{'start_time'}, $r{"size_lexicon_$index"}) if defined $r{"size_lexicon_$index"};
	}
});

$pic->draw_picture;
